#!/usr/bin/env bash
set -euo pipefail

# Bootstrap and run the mass‑gap simulation end‑to‑end.
#
# This helper script performs three stages:
#
#  1. Generate flip counts via the loop‑fluctuation simulator.  The
#     resulting ``flip_counts.npy`` will be placed under
#     ``data/results/vol4_loop_fluctuation_sim`` according to the
#     configuration.
#  2. Run the mass‑gap simulation using the shared configuration and
#     write its summary CSV into ``data/results/vol4_mass_gap_sim``.
#  3. Generate a Markdown report summarising the results and save it
#     alongside the simulation code in ``vol4_mass_gap_sim``.

ROOT="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"

echo "[1] flip‑count simulation"
# Ensure any optional ar‑operator‑core dependencies are discoverable
export PYTHONPATH="$ROOT/../ar-operator-core/ar-operator-core${PYTHONPATH:+:$PYTHONPATH}"
python "$ROOT/../vol4_loop_fluctuation_sim/run.py" \
  --config "$ROOT/../configs/default.yaml" \
  --output-dir "$ROOT/../data/results/vol4_loop_fluctuation_sim"

echo "[2] mass‑gap simulation"
python "$ROOT/run.py" \
  --config "$ROOT/../configs/default.yaml" \
  --output-dir "$ROOT/../data/results/vol4_mass_gap_sim"

echo "[3] report"
python "$ROOT/scripts/generate_report.py"

echo "Done"